/*! \file 
**********************************************************************************
*Title:                         Discretix Toolkit Certificate Handling ATP Test source file
*
* Filename:                      CERT_TLK_ATP_CertificateIdCompute.c 
*
* 
* Created:                       18.03.2008
*
*
* \Author                        Sagit Ben Tsur
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
/************* Include Files ***********************************/
#include "DX_VOS_BaseTypes.h"
#include "CERT_TLK_ATP_util.h"
#include "CERT_TLK_ATP_data.h"
#include "DX_VOS_Mem.h"
#include "CERT_TLK_ATP_tests.h"
#include "DX_VOS_Stdio.h"
#include "tlk_cert_api.h"
#include "tlk_cert_api_odrm.h"
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"
#include "DX_VOS_Mem.h"
#ifndef TLK_CERT_NO_SCLK
#include "tlk_sclk_api_types.h"
#else
#include "tlk_cert_sclk_api_stub_types.h"
#endif




/********************************************************************************************************************
  * Function Name:                                                           
  *  TST_ATP_TLK_CERT_CertificateIdCompute
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *    Test TLK_CERT_CertificateIdCompute
  *  
  * Algorithm: 
  * 1.	Call the API. TLK_CERT_CertificateIdCompute.
  * 2.	Compare the out value of certificateId_ptr with the calculated certificate identifier generated in advance. 
  ******************************************************************************************************************/   
DxError_t TST_ATP_TLK_CERT_CertificateIdCompute()
{
   DxError_t                   TST_Status;
   TLK_CERT_Buffer_t           certificate_ptr ;
   DxSha1Result_t              certificateId ;
   DxChar_t                    TestName[] = "TST_ATP_TLK_CERT_CertificateIdCompute";
       
   /*load parameters*/
   certificate_ptr.buff_ptr          =  TST_gEECertificate;
   certificate_ptr.buffSizeInBytes   =  TST_gEECertificateSize;


   /*1. Call the API. TLK_CERT_CertificateIdCompute.*/
   TST_Status =  TLK_CERT_CertificateIdCompute(&certificate_ptr,certificateId);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_CertificateIdCompute", TestName,TestName)


   /*2.	Compare the out value of certificateId_ptr with the calculated certificate identifier generated in advance.*/
   if(0 != DX_VOS_MemCmp(certificateId,TST_gCertificateId,sizeof(DxSha1Result_t)))
      TST_Status = TST_FAIL; 
   else
      TST_Status = TST_PASS; 
  
   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - certificateId_ptr->buff_ptr", TestName, TestName)
     

   ATP_LOG_TST_PRINT((MW_ATP_MSG," *********************************************************\n\n"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG," ** TST_ATP_TLK_CERT_CertificateIdCompute Test  PASS !!!  \n"));     
   ATP_LOG_TST_PRINT((MW_ATP_MSG," ******************************************************** \n \n"));

   return TST_PASS;

EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }

}

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_CERT_CertificateParamGet
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test TLK_CERT_CertificateParamGet
*  
* 1.Call the API. TLK_CERT_CertificateParamGet.
* 2.Compare the out value of certificateParamList_ptr with the calculated certificate TLK_CERT_CertProcessParameters_t
*   that was with inputs from the certificate in advance.
*******************************************************************************/   
DxError_t TST_ATP_TLK_CERT_CertificateParamGet(void)
{

   DxError_t                   TST_Status;
   DxChar_t                    TestName[] = "TST_ATP_TLK_CERT_CertificateParamGet";
   TLK_CERT_Buffer_t           certificate;
   TLK_CERT_CertParameters_t   certificateParamList;

   /*load parameters*/
   certificate.buff_ptr          =  TST_gEECertificate;
   certificate.buffSizeInBytes   =  TST_gEECertificateSize;


   /*1.Call the API. TLK_CERT_CertificateParamGet.*/
    TST_Status = TLK_CERT_CertificateParamGet(&certificate,&certificateParamList);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_CertificateParamGet",TestName, TestName)
  

   /*2.	Compare the out value of certificateParamList_ptr with the calculated certificate      */
   /*   TLK_CERT_CertProcessParameters_t  that was with inputs from the certificate in advance.*/

   /*subjectName*/
   /*----------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectNameEE,&certificateParamList.subjectName,sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS; 

    TST_ATP_CheckErrorReturn(TST_Status,"DX_VOS_MemCmp - subjectName", TestName, TestName);
     

   /*issuerName*/
   /*----------*/
   if(0 != DX_VOS_MemCmp(&TST_gIssuerNameEE,&certificateParamList.issuerName,sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - issuerName", TestName, TestName)
     

   /*ValidNotBefore*/
   /*---------------*/
   if(0 != DX_VOS_MemCmp(&TST_gValidNotBeforeEE,&certificateParamList.validNotBefore,sizeof(DxGeneralizedTime_t)))
     TST_Status = TST_FAIL; 
    else
     TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - validNotBefore", TestName, TestName)
     

   /*validNotAfter*/
   /*---------------*/
   if(0 != DX_VOS_MemCmp(&TST_gValidNotAfterEE,&certificateParamList.validNotAfter,sizeof(DxGeneralizedTime_t)))
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - validNotAfter", TestName, TestName)
    

   /*TST_gSubjectPublicKeyInfoEE*/
   /*---------------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectPublicKeyInfoEE,
                         &certificateParamList.subjectPublicKeyInfo.subjectPublicKeyInfoDER,
                          sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectPublicKeyBuff, DER Format",TestName,TestName)
     

   /*TST_gSubjectPublicKeyInfoModulus*/
   /*--------------------------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectPublicKeyInfoModulus,
       &certificateParamList.subjectPublicKeyInfo.subjectPublicKeyInfoValues.modulus,
       2*sizeof(DxUint32_t)))
       TST_Status = TST_FAIL; 
   else
       TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectPublicKeyBuff, Real Value, Modulus",TestName,TestName)

   /*TST_gSubjectPublicKeyInfoExponent*/
   /*---------------------------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectPublicKeyInfoExponent,
       &certificateParamList.subjectPublicKeyInfo.subjectPublicKeyInfoValues.exponent,
       sizeof(TLK_CERT_BufferOffest_t)))
       TST_Status = TST_FAIL; 
   else
       TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectPublicKeyBuff, Real Value, Exponent",TestName,TestName)
       


    /*keyUsage*/
   /*---------*/
   if(0 != DX_VOS_MemCmp(&TST_gKeyUsageEE,&certificateParamList.keyUsage, sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keyUsage",TestName,TestName);
    


   ATP_LOG_TST_PRINT((MW_ATP_MSG," *******************************************************\n\n"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG," ** TST_ATP_TLK_CERT_CertificateParamGet Test  PASS !!!  \n"));     
   ATP_LOG_TST_PRINT((MW_ATP_MSG," ******************************************************* \n \n"));

   return TST_PASS;

   EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }

}

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_CERT_CertificateChainValidation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test TLK_CERT_ChainValidationInit, TLK_CERT_ChainValidationProcess and TLK_CERT_ChainValidationTerminate
*  
* Algorithm: 
*1.	Call TLK_CERT_ChainValidationInit.
*2.	Call TLK_CERT_ChainValidationProcess 3 times on the sequence of the chain every time the API will get the updated 
*   context from the previous call.
*3.	Call TLK_CERT_ChainValidTerminate 
*4.	Validate the TLK_CERT_CPVO_t have the correct fields: subjectNameTR and issuerNameTR from the trusted root 
*   certificate subjectNameEE and issuerNameEE from the first certificate in the chain are the same and 
*   all other fields equal the fields from the certificate.    
********************************************************************************/  
DxError_t TST_ATP_TLK_CERT_CertificateChainValidation(void)
{
   DxError_t                  TST_Status;
   TLK_CERT_ContextObj_t      contextObject;
   TLK_CERT_CPVO_t            cvpoObject;
   DxChar_t                   TestName[] = "TST_ATP_TLK_CERT_CertificateChainValidation";

   TLK_CERT_Buffer_t currCertificate;
   TLK_CERT_Buffer_t prevCertificate;

   DxBool_t TST_TrustedRootFromSecuredEnv = DX_FALSE;


   /*1.Call TLK_CERT_ChainValidationInit.*/
   TST_Status = TLK_CERT_ChainValidationInit(&contextObject);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_ChainValidationInit ", TestName,TestName);
    

   /*Call TLK_CERT_ChainValidationProcess 3 times on the sequence of the chain every time the API will get the updated 
   context from  the previous call.*/

   prevCertificate.buff_ptr        = DX_NULL;
   prevCertificate.buffSizeInBytes = 0;
   currCertificate.buff_ptr        = TST_gEECertificate;
   currCertificate.buffSizeInBytes = TST_gEECertificateSize;
   TST_Status = TLK_CERT_ChainValidationProcess(&prevCertificate,
                                               &currCertificate,
                                               &TST_gServiceClockDesc,
                                               &TST_gServiceClockPwd,
                                               &contextObject,
                                               TST_gCWorkspace,
                                               TST_gCWorkspaceSizeInBytes);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_ChainValidationProcess aEECertificate", TestName, TestName);
                              
   prevCertificate.buff_ptr        = TST_gEECertificate;
   prevCertificate.buffSizeInBytes = TST_gEECertificateSize;
   currCertificate.buff_ptr        = TST_g1Certificate;
   currCertificate.buffSizeInBytes = TST_g1CertificateSize;
   
   TST_Status = TLK_CERT_ChainValidationProcess(&prevCertificate,
                                               &currCertificate,
                                               &TST_gServiceClockDesc,
                                               &TST_gServiceClockPwd,
                                               &contextObject,
                                               TST_gCWorkspace,
                                               TST_gCWorkspaceSizeInBytes);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_ChainValidationProcess aCurrCertificate1", TestName, TestName);


   prevCertificate.buff_ptr        = TST_g1Certificate;
   prevCertificate.buffSizeInBytes = TST_g1CertificateSize;
   currCertificate.buff_ptr        = TST_g2Certificate;
   currCertificate.buffSizeInBytes = TST_g2CertificateSize;

   TST_Status = TLK_CERT_ChainValidationProcess(&prevCertificate,
                                               &currCertificate,
                                               &TST_gServiceClockDesc,
                                               &TST_gServiceClockPwd,
                                               &contextObject,
                                               TST_gCWorkspace,
                                               TST_gCWorkspaceSizeInBytes);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_ChainValidationProcess aCurrCertificate2", TestName, TestName);
                               

   prevCertificate.buff_ptr        = TST_g2Certificate;
   prevCertificate.buffSizeInBytes = TST_g2CertificateSize;
   currCertificate.buff_ptr        = TST_gTRCertificate;
   currCertificate.buffSizeInBytes = TST_gTRCertificateSize;

   /*Call TLK_CERT_ChainValidProcess with the parameter sstAccessParams  the root Ca.*/
   TST_Status = TLK_CERT_ChainValidationProcess(&prevCertificate,
                                               &currCertificate,
                                               &TST_gServiceClockDesc,
                                               &TST_gServiceClockPwd,
                                               &contextObject,
                                               TST_gCWorkspace,
                                               TST_gCWorkspaceSizeInBytes);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_ChainValidationProcess aRootCertificate",TestName,TestName);



   /*Call TLK_CERT_ChainValidTerminate*/
   TST_Status = TLK_CERT_ChainValidationTerminate(&contextObject,&cvpoObject);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_ChainValidationTerminate", TestName,TestName);



   /*Validate the TLK_CERT_CPVO_t have the correct fields: subjectNameTR and issuerNameTR from the trusted root 
    certificate,  subjectNameEE and issuerNameEE from the first certificate in the chain are the same and all 
    other fields equal the fields  from the certificate.*/


   /*subjectNameEE*/
   /*-------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectNameEE,&cvpoObject.cvpoPart.subjectNameEE, sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
   else
    TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectNameEE", TestName, TestName);
     

   /*signatureTR*/
   /*-------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSignatureTR,&cvpoObject.cvpoPart.signatureTR, sizeof(TLK_CERT_BufferOffest_t)))
    TST_Status = TST_FAIL; 
   else
    TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - signatureTR", TestName, TestName);
     


   /*subjectKeyIdentifierEE*/
   /*---------------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectKeyIdentifierEE,&cvpoObject.cvpoPart.subjectKeyIdentifierEE, sizeof(TLK_CERT_BufferOffest_t)))
    TST_Status = TST_FAIL; 
   else
    TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectKeyIdentifierEE", TestName, TestName);
     

   /*subjectPublicKeyInfoEE*/
   /*---------------------*/
    if(0 != DX_VOS_MemCmp(&TST_gSubjectPublicKeyInfoEE,&cvpoObject.cvpoPart.subjectPublicKeyInfoEE,
                          2*sizeof(DxUint32_t)))
     TST_Status = TST_FAIL; 
    else
     TST_Status = TST_PASS; 
      
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectPublicKeyInfoEE", TestName, TestName);
     


    /*ValidNotBefore*/
    /*---------------*/
    if(0 != DX_VOS_MemCmp(&TST_gValidNotBeforeEE,&cvpoObject.cvpoPart.validNotBeforeEE,sizeof(DxGeneralizedTime_t)))
      TST_Status = TST_FAIL; 
    else
      TST_Status = TST_PASS; 

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - validNotBeforeEE", TestName, TestName);
      

    /*validNotAfter*/
    /*---------------*/
    if(0 != DX_VOS_MemCmp(&TST_gValidNotAfterEE,&cvpoObject.cvpoPart.validNotAfterEE,sizeof(DxGeneralizedTime_t)))
      TST_Status = TST_FAIL; 
    else
      TST_Status = TST_PASS; 

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - validNotAfterEE", TestName, TestName);
  
   
   /*keyUsageEE*/
   /*----------*/
    if(0 != DX_VOS_MemCmp(&TST_gKeyUsageEE,&cvpoObject.cvpoPart.keyUsageEE, sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
    else
     TST_Status = TST_PASS; 
      
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keyUsageEE",TestName, TestName);
  
   /*subjectNameTR*/
   /*--------------*/
   if(0 != DX_VOS_MemCmp(&TST_gSubjectNameTR,&cvpoObject.cvpoPart.subjectNameTR, sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS; 
     
   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectNameTR", TestName, TestName);

   /*subjectKeyIdentifierTR*/
   /*---------------------*/
   if(0 != DX_VOS_MemCmp(&TST_gsubjectKeyIdentifierTR,&cvpoObject.cvpoPart.subjectKeyIdentifierTR, sizeof(TLK_CERT_BufferOffest_t)))
     TST_Status = TST_FAIL; 
    else
     TST_Status = TST_PASS; 

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectKeyIdentifierTR", TestName, TestName);

   /*subjectPublicKeyInfoTR*/
   /*---------------------*/
    if(0 != DX_VOS_MemCmp(&TST_gSubjectPublicKeyInfoTR,&cvpoObject.cvpoPart.subjectPublicKeyInfoTR, sizeof(TLK_CERT_BufferOffest_t)))
      TST_Status = TST_FAIL; 
    else
      TST_Status = TST_PASS; 
 
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - subjectPublicKeyInfoTR", TestName, TestName);

  
   
   /*trustedRootFromSecuredEnv*/
   /*-------------------------*/
   if(cvpoObject.cvpoPart.trustedRootFromSecuredEnv != TST_TrustedRootFromSecuredEnv )
     TST_Status = TST_FAIL; 
   else
     TST_Status = TST_PASS;

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - trustedRootFromSecuredEnv", TestName, TestName);

   ATP_LOG_TST_PRINT((MW_ATP_MSG," ***************************************************************\n\n"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG," ** TST_ATP_TLK_CERT_CertificateChainValidation Test  PASS !!!  \n"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG," ************************************************************** \n \n"));

   return TST_PASS;

   EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}







